#version 330
#extension GL_EXT_gpu_shader4 : enable
// Simple mountainsMod01.fsh  by Dijkstra
//https://www.shadertoy.com/view/wtdXR8
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels


#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize


//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

float rand21(vec2 uv){
 	return fract(sin(uv.x*12165431.+uv.y*452654.)*94121.);
}

float smoothnoise(vec2 uv, float size){
    vec2 lv = smoothstep(0.,1., fract(uv*size));
    vec2 id = floor(uv*size);
    
    float bl = rand21(id + vec2(0.,0.));
    float br = rand21(id + vec2(1.,0.));
    float tl = rand21(id + vec2(0.,1.));
    float tr = rand21(id + vec2(1.,1.));
    float b = mix(bl, br, lv.x);
    float t = mix(tl, tr, lv.x);
    float c = mix(b, t, lv.y);
    
    return c;
}

float smoothMore(vec2 uv, float size){
    float total = smoothnoise(uv, size);
    total += smoothnoise(uv, size*2.)/4.;
    total += smoothnoise(uv, size*4.)/8.;
    total += smoothnoise(uv, size*8.)/16.;
    total += smoothnoise(uv, size*16.)/32.;
 	return total;
}

vec4 sphere(vec3 p, vec3 spherePosition, float radius){
	return vec4(length(abs(p-spherePosition)) - radius, 1.,1.,.6);
}

vec4 ground(vec3 p){
    float offset = smoothMore(vec2(p.x,p.z), .5)*1.5;
    float cursor = p.y+1.5;
	return vec4(p.y+2. - offset, 
                mix(.44, 1., cursor), 		//r
                mix(.35, 1., cursor), 		//g
                mix(.25, 1., cursor));		//b
}

vec4 scene(vec3 p){
    vec4 d1 = sphere(p, vec3(25., 8., 20. + iTime), 1.);
    vec4 d2 = ground(p);
    if(d1.x < d2.x)
        return d1;
    return d2;
}

const float EPSILON = 0.0001;

vec3 estimateNormal(vec3 p) {
    return normalize(vec3(
        scene(vec3(p.x + EPSILON, p.y, p.z)).x - scene(vec3(p.x - EPSILON, p.y, p.z)).x,
        scene(vec3(p.x, p.y + EPSILON, p.z)).x - scene(vec3(p.x, p.y - EPSILON, p.z)).x,
        scene(vec3(p.x, p.y, p.z  + EPSILON)).x - scene(vec3(p.x, p.y, p.z - EPSILON)).x
    ));
}

float getLight(vec3 p){
 	vec3 lightPos = vec3(22., 10.,iTime+3.);
    vec3 ld = normalize(lightPos-p);
    vec3 n = estimateNormal(p);
    
    float dif = dot(n,ld);
    return dif;
}

float glowing(vec3 p){
 	 return sphere(p, vec3(25., 8., 20. + iTime), 1.).x;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = gl_FragCoord.xy/iResolution.xy;
    uv-=.5;
    uv.x *= (iResolution.x/iResolution.y);

    
    vec3 ro = vec3(15.,0.,-3.+iTime);
    vec3 rd = normalize(vec3(uv,1.));
    vec3 rp = ro;
   	vec3 col = vec3(.3,.4,.98);
    float i = 0.;
    for(i=0.; i<100.; ++i){
    	float dist = scene(rp).x;
        rp += rd * dist;
        if(dist < .01){
            col = scene(rp).yzw;
            col *= vec3(getLight(rp));
        	break;
        }
        if(dist>100.) break;
    }
    
    
    rp = ro;
    for(i=0.; i<100.; ++i){
    	float dist = glowing(rp);
        rp += rd * dist;
        if(dist < 1.){
            col += vec3(.03);
        }
        if(dist>100.) break;
    }
    


    // Output to screen
    //fragColor = vec4(vec3(smoothMore(uv, 11.)),1.0);
    gl_FragColor = vec4(col,1.0);
}